﻿using System;
using VIRP_WEB.Controls.Custom.EFR.Controls;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class BioLabResultUserControl : System.Web.UI.UserControl
    {
        private bool labReportDateIsReadOnly;

        protected void Page_Load(object sender, EventArgs e)
        {
            RangeValidatorForlblReportDate.MaximumValue =
                RangeValidatorForSpecimenCollectionDate.MaximumValue =
                    DateTime.Today.AddYears(100).ToShortDateString();
        }

        /// <summary>
        /// Determines if Lab Report Date field is a read only label or an editable text box
        /// </summary>
        public bool LabReportDateIsReadOnly
        {
            set
            {
                if (value == true)
                {
                    TextBoxReportDate.Visible = false;
                    lblReportDate.Visible = true;
                    LabelReportDateLabel.Text = LabelReportDateLabel.Text.Replace(" (mm/dd/yyyy)", "");
                    LabelReportDateLabel.SkinID = "Datalabel";
                    LabelReportDateLabel.AssociatedControlID = lblReportDate.ID;
                }
                else
                {
                    TextBoxReportDate.Visible = true;
                    lblReportDate.Visible = false;
                    LabelReportDateLabel.SkinID = "Datalabel";
                }

                labReportDateIsReadOnly = value;
            }
        }

        public void SetfieldValues(PatientLabInfo info, bool linkPatientWorkflows)
        {
            ChangeHistoryUserControl.WorkFlowCalseId = info.WorkFlowCaseId;
            ChangeHistoryUserControl.ControlWidth = PanelPatient.Width;

            if (linkPatientWorkflows)
            {
                patientWorkflowsLink.Text = BaseCode.Helpers.AntiXssEval(info.Name);
                patientWorkflowsLink.NavigateUrl = string.Format("~/Custom/EFR/Patients/PatientWorkflows.aspx?patientId={0}", info.ID);
                lblFullName.Visible = false;
                patientWorkflowsLink.Visible = true;
                LabelforFullNameLabel.AssociatedControlID = patientWorkflowsLink.ID;
            }
            else
            {
                lblFullName.Text = BaseCode.Helpers.AntiXssEval(info.Name);
                lblFullName.Visible = true;
                patientWorkflowsLink.Visible = false;
                LabelforFullNameLabel.AssociatedControlID = lblFullName.ID;
            }

            lblReportDate.Text = info.ReportDate;
            TextBoxReportDate.Text = info.ReportDate;
            lblICN.Text = BaseCode.Helpers.AntiXssEval(info.ICN);
            lblSnum.Text = BaseCode.Helpers.AntiXssEval(info.Snum);
            lblGender.Text = BaseCode.Helpers.AntiXssEval(info.Gender);
            lblBirthday.Text = info.BirthDate;
            lblPostalCode.Text = BaseCode.Helpers.AntiXssEval(info.PostalCode);
            txtLabContact.Text = BaseCode.Helpers.AntiXssEval(info.LabContact ?? "Dr. Brown");

            txtAccession.Text = info.Accession;
            lblLabName.Text = BaseCode.Helpers.AntiXssEval(info.LabName);
            TextBoxSpecimenCollectionDate.Text = info.SpecColnDate;

            var kitReceivedDate = BaseCode.Helpers.AntiXssEval(info.KitReceivedDate);
            lblKitReceivedDate.Text = kitReceivedDate;
            KitReceivedDateHiddenBox.Text = kitReceivedDate;
        }

        public void GetfieldValues(PatientLabInfo info)
        {
            if (lblFullName.Visible)
                info.Name = lblFullName.Text.Trim();
            else
                info.Name = patientWorkflowsLink.Text.Trim();

            info.ReportDate = lblReportDate.Text;

            if (!labReportDateIsReadOnly)
            {
                info.ReportDate = TextBoxReportDate.Text;
            }

            info.ICN = lblICN.Text;
            info.Snum = lblSnum.Text;
            info.Gender = lblGender.Text;
            info.PostalCode = lblPostalCode.Text;
            info.BirthDate = lblBirthday.Text;
            info.LabContact = txtLabContact.Text.Trim();
            info.SpecColnDate = TextBoxSpecimenCollectionDate.Text;
            info.LabName = lblLabName.Text;
            info.Accession = txtAccession.Text.Trim();
        }
    }
}